/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.password;

import com.ibm.hwmca.base.password.PasswordBean;
import com.ibm.hwmca.base.userprof.UserAttributes;
import com.ibm.hwmca.base.userprof.UserProfTasklet;
import com.ibm.hwmca.base.userprof.UserProfilesException;
import com.ibm.hwmca.base.userprof.UserProfilesPlugin;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public class PasswordTasklet
extends PanelTasklet {
    PasswordBean passwordBean;
    private static final String TRACE_MASKF = "PASSTKTF";
    private static final String TRACE_MASKT = "PASSTKTT";
    private static final String TRACE_MASKD = "PASSTKTD";
    private static boolean panelUp = false;
    private static final String PASSWORDBEAN_NAME = "PasswordBean";
    UserProfilesPlugin implClass;
    String password = "PASSWORD";
    private LocalizableText lStrBusy;
    private LocalizableText lStrUpdate;
    private LocalizableText lStrTitle;
    private LocalizableText lText;

    public void init(PresentationTaskParms parms) {
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "<> PasswordServerTasklet.logException()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKT, "-> PasswordTasklet.service()");
            this.implClass = UserProfTasklet.loadPlugin();
            if (this.implClass == null) {
                BaseMessageTitle title = new BaseMessageTitle("ADM9016");
                MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("ADM0019")};
                LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                try {
                    LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0019", MsgType.INFORMATION_MESSAGE, options);
                }
                catch (Exception exc) {
                    HException ex = new HException(exc);
                }
                response.noAction();
            } else {
                try {
                    UserAttributes curUser = this.implClass.getUser(User.getUser().getUserName());
                    Trace.trace(TRACE_MASKT, "PasswordTasklet.initialrequest ");
                    Trace.trace(TRACE_MASKT, "User = " + curUser.getUserid());
                    Trace.trace(TRACE_MASKT, "Desc = " + curUser.getDescription());
                    PasswordBean passwordBean = new PasswordBean(curUser.getRequiresOldPassword());
                    passwordBean.setBeanName(PASSWORDBEAN_NAME);
                    response.openModalChild("com.ibm.hwmca.base.password.res.PasswordRes", "PasswordPanel", passwordBean);
                }
                catch (UserProfilesException e) {
                    BaseMessageTitle title = new BaseMessageTitle("ADM9017");
                    MessageText[] bmt = new BaseMessageText[1];
                    Object[] values = new String[]{e.getLocalizedMessage()};
                    bmt[0] = new BaseMessageText("ADM0023", values);
                    LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                    try {
                        LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0023", MsgType.INFORMATION_MESSAGE, options);
                    }
                    catch (Exception exc) {
                        HException ex = new HException(exc);
                    }
                    response.noAction();
                }
            }
        } else if (request.isDisposed() || request.isCanceled()) {
            if (panelUp) {
                response.dispose();
                panelUp = false;
            } else {
                response.terminate();
            }
        } else {
            String myAction = (String)request.getData("action");
            Trace.trace(TRACE_MASKT, "-> PasswordTasklet.action() " + myAction);
            if (myAction.equalsIgnoreCase("CANCEL")) {
                response.terminate();
            } else if (myAction.equalsIgnoreCase("setpassword")) {
                try {
                    String password = (String)request.getData("password");
                    String oldpassword = (String)request.getData("oldpassword");
                    Trace.trace(TRACE_MASKT, "-> PasswordTasklet.password received " + password);
                    UserAttributes curUser = this.implClass.getUser(User.getUser().getUserName());
                    Trace.trace(TRACE_MASKT, "Curuser attributes in setpassword ");
                    Trace.trace(TRACE_MASKT, "User = " + curUser.getUserid());
                    Trace.trace(TRACE_MASKT, "Desc = " + curUser.getDescription());
                    Trace.trace(TRACE_MASKT, "-> PasswordTasklet.curUser " + curUser);
                    if (oldpassword != null) {
                        Trace.trace(TRACE_MASKT, "-> PasswordTasklet.oldpassword " + oldpassword);
                        this.implClass.checkPassword(curUser.getUserid(), oldpassword);
                    }
                    if (curUser.isPasswordRulesEnforced()) {
                        this.implClass.validatePassword(password, true);
                        Trace.trace(TRACE_MASKT, "-> PasswordTasklet.isEnforced ");
                    } else {
                        this.implClass.validatePassword(password, false);
                        Trace.trace(TRACE_MASKT, "-> PasswordTasklet.isNotEnforced ");
                    }
                    String name = curUser.getUserid();
                    byte[] pass = password.getBytes();
                    LocalizableText desc = curUser.getDescription();
                    Trace.trace(TRACE_MASKT, "Data for modify ");
                    Trace.trace(TRACE_MASKT, "User = " + name);
                    Trace.trace(TRACE_MASKT, "Desc = " + curUser.getDescription());
                    UserAttributes userAttr = new UserAttributes(name, pass, desc);
                    Trace.trace(TRACE_MASKT, "Userattributes before modifyUser ");
                    Trace.trace(TRACE_MASKT, "User = " + userAttr.getUserid());
                    Trace.trace(TRACE_MASKT, "Desc = " + userAttr.getDescription());
                    userAttr.setPasswordRulesEnforced(curUser.isPasswordRulesEnforced());
                    userAttr.setPasswordExpiration(curUser.getPasswordExpiration());
                    this.implClass.modifyUser(userAttr);
                    UserAttributes tst = this.implClass.getUser(User.getUser().getUserName());
                    Trace.trace(TRACE_MASKT, "Userattributes after modifyUser ");
                    Trace.trace(TRACE_MASKT, "User = " + tst.getUserid());
                    Trace.trace(TRACE_MASKT, "Desc = " + tst.getDescription());
                    response.dispose(PASSWORDBEAN_NAME);
                }
                catch (UserProfilesException e) {
                    BaseMessageTitle title = new BaseMessageTitle("ADM9017");
                    MessageText[] bmt = new BaseMessageText[1];
                    Object[] values = new String[]{e.getLocalizedMessage()};
                    bmt[0] = new BaseMessageText("ADM0023", values);
                    LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                    try {
                        LocalizableText answer = this.showMessageBox(false, title, bmt, "ADM0023", MsgType.INFORMATION_MESSAGE, options);
                    }
                    catch (Exception exc) {
                        HException ex = new HException(exc);
                    }
                    response.noAction();
                }
            } else {
                response.noAction();
            }
        }
    }
}

